﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Demo
{
    public partial class frmSelectFile : Form
    {
        public frmSelectFile()
        {
            InitializeComponent();

            //Added to support default instance behavour in C#
            if (defaultInstance == null)
                defaultInstance = this;
        }

        #region Default Instance

        private static frmSelectFile defaultInstance;

        public static frmSelectFile Default
        {
            get
            {
                if (defaultInstance == null)
                {
                    defaultInstance = new frmSelectFile();
                    defaultInstance.FormClosed += new FormClosedEventHandler(defaultInstance_FormClosed);
                }

                return defaultInstance;
            }
        }

        static void defaultInstance_FormClosed(object sender, FormClosedEventArgs e)
        {
            defaultInstance = null;
        }

        #endregion

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog openDialog = new OpenFileDialog();
            openDialog.FileName = "";
            openDialog.Filter = "CSS Files(*.css)|*.css";
            openDialog.FilterIndex = 8;
            openDialog.Title = "Select File";
            if (openDialog.ShowDialog() == DialogResult.OK)
            {
                txtURL.Text = openDialog.FileName;
                txtURL.Focus();
            }
        }

        private void frmSelectFile_Activated(object sender, EventArgs e)
        {
            txtURL.Focus();
            if (txtURL.Text.Length > 0)
            {
                btnOK.Enabled = true;
            }
            else
            {
                btnOK.Enabled = false;
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            clsGlobal.returnValue = "";
            this.Close();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            clsGlobal.returnValue = txtURL.Text;
            this.Close();
        }

        private void txtURL_TextChanged(object sender, EventArgs e)
        {
            if (txtURL.Text.Length > 0)
            {
                btnOK.Enabled = true;
            }
            else
            {
                btnOK.Enabled = false;
            }
        }

    }
}
